package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  Timestamp,
  WorkspaceName,
  WorkspaceId,
  Description,
  Endpoint,
  GrafanaVersion
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class WorkspaceDescription(
    accountAccessType: Option[zio.aws.grafana.model.AccountAccessType] = None,
    authentication: zio.aws.grafana.model.AuthenticationSummary,
    created: Timestamp,
    dataSources: Iterable[zio.aws.grafana.model.DataSourceType],
    description: Option[Description] = None,
    endpoint: Endpoint,
    freeTrialConsumed: Option[Boolean] = None,
    freeTrialExpiration: Option[Timestamp] = None,
    grafanaVersion: GrafanaVersion,
    id: WorkspaceId,
    licenseExpiration: Option[Timestamp] = None,
    licenseType: Option[zio.aws.grafana.model.LicenseType] = None,
    modified: Timestamp,
    name: Option[WorkspaceName] = None,
    notificationDestinations: Option[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    organizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    permissionType: Option[zio.aws.grafana.model.PermissionType] = None,
    stackSetName: Option[StackSetName] = None,
    status: zio.aws.grafana.model.WorkspaceStatus,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.WorkspaceDescription = {
    import WorkspaceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .authentication(authentication.buildAwsValue())
      .created(Timestamp.unwrap(created): Instant)
      .dataSourcesWithStrings(dataSources.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .endpoint(Endpoint.unwrap(endpoint): java.lang.String)
      .optionallyWith(freeTrialConsumed.map(value => value: java.lang.Boolean))(
        _.freeTrialConsumed
      )
      .optionallyWith(
        freeTrialExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.freeTrialExpiration)
      .grafanaVersion(GrafanaVersion.unwrap(grafanaVersion): java.lang.String)
      .id(WorkspaceId.unwrap(id): java.lang.String)
      .optionallyWith(
        licenseExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.licenseExpiration)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .modified(Timestamp.unwrap(modified): Instant)
      .optionallyWith(
        name.map(value => WorkspaceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        notificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationDestinationsWithStrings)
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .optionallyWith(
        organizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnits)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .status(status.unwrap)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
    zio.aws.grafana.model.WorkspaceDescription.wrap(buildAwsValue())
}
object WorkspaceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.WorkspaceDescription =
      zio.aws.grafana.model.WorkspaceDescription(
        accountAccessType.map(value => value),
        authentication.asEditable,
        created,
        dataSources,
        description.map(value => value),
        endpoint,
        freeTrialConsumed.map(value => value),
        freeTrialExpiration.map(value => value),
        grafanaVersion,
        id,
        licenseExpiration.map(value => value),
        licenseType.map(value => value),
        modified,
        name.map(value => value),
        notificationDestinations.map(value => value),
        organizationRoleName.map(value => value),
        organizationalUnits.map(value => value),
        permissionType.map(value => value),
        stackSetName.map(value => value),
        status,
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: Option[zio.aws.grafana.model.AccountAccessType]
    def authentication: zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    def created: Timestamp
    def dataSources: List[zio.aws.grafana.model.DataSourceType]
    def description: Option[Description]
    def endpoint: Endpoint
    def freeTrialConsumed: Option[Boolean]
    def freeTrialExpiration: Option[Timestamp]
    def grafanaVersion: GrafanaVersion
    def id: WorkspaceId
    def licenseExpiration: Option[Timestamp]
    def licenseType: Option[zio.aws.grafana.model.LicenseType]
    def modified: Timestamp
    def name: Option[WorkspaceName]
    def notificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]]
    def organizationRoleName: Option[OrganizationRoleName]
    def organizationalUnits: Option[List[OrganizationalUnit]]
    def permissionType: Option[zio.aws.grafana.model.PermissionType]
    def stackSetName: Option[StackSetName]
    def status: zio.aws.grafana.model.WorkspaceStatus
    def workspaceRoleArn: Option[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, AwsError, zio.aws.grafana.model.AccountAccessType] =
      AwsError.unwrapOptionField("accountAccessType", accountAccessType)
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    ] = ZIO.succeed(authentication)
    def getCreated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(created)
    def getDataSources
        : ZIO[Any, Nothing, List[zio.aws.grafana.model.DataSourceType]] =
      ZIO.succeed(dataSources)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpoint)
    def getFreeTrialConsumed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("freeTrialConsumed", freeTrialConsumed)
    def getFreeTrialExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("freeTrialExpiration", freeTrialExpiration)
    def getGrafanaVersion: ZIO[Any, Nothing, GrafanaVersion] =
      ZIO.succeed(grafanaVersion)
    def getId: ZIO[Any, Nothing, WorkspaceId] = ZIO.succeed(id)
    def getLicenseExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("licenseExpiration", licenseExpiration)
    def getLicenseType: ZIO[Any, AwsError, zio.aws.grafana.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getModified: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modified)
    def getName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("name", name)
    def getNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "notificationDestinations",
      notificationDestinations
    )
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getOrganizationalUnits: ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField("organizationalUnits", organizationalUnits)
    def getPermissionType
        : ZIO[Any, AwsError, zio.aws.grafana.model.PermissionType] =
      AwsError.unwrapOptionField("permissionType", permissionType)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStatus: ZIO[Any, Nothing, zio.aws.grafana.model.WorkspaceStatus] =
      ZIO.succeed(status)
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ) extends zio.aws.grafana.model.WorkspaceDescription.ReadOnly {
    override val accountAccessType
        : Option[zio.aws.grafana.model.AccountAccessType] = scala
      .Option(impl.accountAccessType())
      .map(value => zio.aws.grafana.model.AccountAccessType.wrap(value))
    override val authentication
        : zio.aws.grafana.model.AuthenticationSummary.ReadOnly =
      zio.aws.grafana.model.AuthenticationSummary.wrap(impl.authentication())
    override val created: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.created())
    override val dataSources: List[zio.aws.grafana.model.DataSourceType] = impl
      .dataSources()
      .asScala
      .map { item =>
        zio.aws.grafana.model.DataSourceType.wrap(item)
      }
      .toList
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val endpoint: Endpoint =
      zio.aws.grafana.model.primitives.Endpoint(impl.endpoint())
    override val freeTrialConsumed: Option[Boolean] =
      scala.Option(impl.freeTrialConsumed()).map(value => value: Boolean)
    override val freeTrialExpiration: Option[Timestamp] = scala
      .Option(impl.freeTrialExpiration())
      .map(value => zio.aws.grafana.model.primitives.Timestamp(value))
    override val grafanaVersion: GrafanaVersion =
      zio.aws.grafana.model.primitives.GrafanaVersion(impl.grafanaVersion())
    override val id: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.id())
    override val licenseExpiration: Option[Timestamp] = scala
      .Option(impl.licenseExpiration())
      .map(value => zio.aws.grafana.model.primitives.Timestamp(value))
    override val licenseType: Option[zio.aws.grafana.model.LicenseType] = scala
      .Option(impl.licenseType())
      .map(value => zio.aws.grafana.model.LicenseType.wrap(value))
    override val modified: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.modified())
    override val name: Option[WorkspaceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val notificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]] =
      scala
        .Option(impl.notificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val organizationRoleName: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value =>
        zio.aws.grafana.model.primitives.OrganizationRoleName(value)
      )
    override val organizationalUnits: Option[List[OrganizationalUnit]] = scala
      .Option(impl.organizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.OrganizationalUnit(item)
        }.toList
      )
    override val permissionType: Option[zio.aws.grafana.model.PermissionType] =
      scala
        .Option(impl.permissionType())
        .map(value => zio.aws.grafana.model.PermissionType.wrap(value))
    override val stackSetName: Option[StackSetName] = scala
      .Option(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val status: zio.aws.grafana.model.WorkspaceStatus =
      zio.aws.grafana.model.WorkspaceStatus.wrap(impl.status())
    override val workspaceRoleArn: Option[IamRoleArn] = scala
      .Option(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ): zio.aws.grafana.model.WorkspaceDescription.ReadOnly = new Wrapper(impl)
}
