package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionsResponse(
    errors: Iterable[zio.aws.grafana.model.UpdateError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse = {
    import UpdatePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly =
    zio.aws.grafana.model.UpdatePermissionsResponse.wrap(buildAwsValue())
}
object UpdatePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdatePermissionsResponse =
      zio.aws.grafana.model.UpdatePermissionsResponse(errors.map { item =>
        item.asEditable
      })
    def errors: List[zio.aws.grafana.model.UpdateError.ReadOnly]
    def getErrors
        : ZIO[Any, Nothing, List[zio.aws.grafana.model.UpdateError.ReadOnly]] =
      ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ) extends zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly {
    override val errors: List[zio.aws.grafana.model.UpdateError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.grafana.model.UpdateError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ): zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
