package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.SsoId
import scala.jdk.CollectionConverters.*
final case class User(id: SsoId, `type`: zio.aws.grafana.model.UserType) {
  def buildAwsValue(): software.amazon.awssdk.services.grafana.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.User
      .builder()
      .id(SsoId.unwrap(id): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.User.ReadOnly =
    zio.aws.grafana.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.grafana.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.User =
      zio.aws.grafana.model.User(id, `type`)
    def id: SsoId
    def `type`: zio.aws.grafana.model.UserType
    def getId: ZIO[Any, Nothing, SsoId] = ZIO.succeed(id)
    def getType: ZIO[Any, Nothing, zio.aws.grafana.model.UserType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.User
  ) extends zio.aws.grafana.model.User.ReadOnly {
    override val id: SsoId = zio.aws.grafana.model.primitives.SsoId(impl.id())
    override val `type`: zio.aws.grafana.model.UserType =
      zio.aws.grafana.model.UserType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.User
  ): zio.aws.grafana.model.User.ReadOnly = new Wrapper(impl)
}
