package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListPermissionsResponse(
    nextToken: Option[PaginationToken] = None,
    permissions: Iterable[zio.aws.grafana.model.PermissionEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListPermissionsResponse = {
    import ListPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .permissions(permissions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListPermissionsResponse.ReadOnly =
    zio.aws.grafana.model.ListPermissionsResponse.wrap(buildAwsValue())
}
object ListPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListPermissionsResponse =
      zio.aws.grafana.model.ListPermissionsResponse(
        nextToken.map(value => value),
        permissions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[PaginationToken]
    def permissions: List[zio.aws.grafana.model.PermissionEntry.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPermissions: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.PermissionEntry.ReadOnly
    ]] = ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ) extends zio.aws.grafana.model.ListPermissionsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
    override val permissions
        : List[zio.aws.grafana.model.PermissionEntry.ReadOnly] = impl
      .permissions()
      .asScala
      .map { item =>
        zio.aws.grafana.model.PermissionEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ): zio.aws.grafana.model.ListPermissionsResponse.ReadOnly = new Wrapper(impl)
}
