package zio.aws.grafana
import zio.prelude.Subtype
import zio.aws.grafana.model.primitives.{
  RoleValue,
  OrganizationalUnit,
  AllowedOrganization
}
import java.time.Instant
import zio.aws.grafana.model.primitives.WorkspaceName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AllowedOrganization extends Subtype[String]
    type AllowedOrganization =
      zio.aws.grafana.model.primitives.AllowedOrganization.Type
    object AssertionAttribute extends Subtype[String]
    type AssertionAttribute =
      zio.aws.grafana.model.primitives.AssertionAttribute.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.grafana.model.primitives.ClientToken.Type
    object Description extends Subtype[String]
    type Description = zio.aws.grafana.model.primitives.Description.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.grafana.model.primitives.Endpoint.Type
    object GrafanaVersion extends Subtype[String]
    type GrafanaVersion = zio.aws.grafana.model.primitives.GrafanaVersion.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.grafana.model.primitives.IamRoleArn.Type
    object IdpMetadataUrl extends Subtype[String]
    type IdpMetadataUrl = zio.aws.grafana.model.primitives.IdpMetadataUrl.Type
    object ListPermissionsRequestMaxResultsInteger extends Subtype[Int]
    type ListPermissionsRequestMaxResultsInteger =
      zio.aws.grafana.model.primitives.ListPermissionsRequestMaxResultsInteger.Type
    object ListWorkspacesRequestMaxResultsInteger extends Subtype[Int]
    type ListWorkspacesRequestMaxResultsInteger =
      zio.aws.grafana.model.primitives.ListWorkspacesRequestMaxResultsInteger.Type
    object LoginValidityDuration extends Subtype[Int]
    type LoginValidityDuration =
      zio.aws.grafana.model.primitives.LoginValidityDuration.Type
    object OrganizationRoleName extends Subtype[String]
    type OrganizationRoleName =
      zio.aws.grafana.model.primitives.OrganizationRoleName.Type
    object OrganizationalUnit extends Subtype[String]
    type OrganizationalUnit =
      zio.aws.grafana.model.primitives.OrganizationalUnit.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.grafana.model.primitives.PaginationToken.Type
    object RoleValue extends Subtype[String]
    type RoleValue = zio.aws.grafana.model.primitives.RoleValue.Type
    object SSOClientId extends Subtype[String]
    type SSOClientId = zio.aws.grafana.model.primitives.SSOClientId.Type
    object SsoId extends Subtype[String]
    type SsoId = zio.aws.grafana.model.primitives.SsoId.Type
    object StackSetName extends Subtype[String]
    type StackSetName = zio.aws.grafana.model.primitives.StackSetName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.grafana.model.primitives.Timestamp.Type
    object UpdateErrorCodeInteger extends Subtype[Int]
    type UpdateErrorCodeInteger =
      zio.aws.grafana.model.primitives.UpdateErrorCodeInteger.Type
    object WorkspaceId extends Subtype[String]
    type WorkspaceId = zio.aws.grafana.model.primitives.WorkspaceId.Type
    object WorkspaceName extends Subtype[String]
    type WorkspaceName = zio.aws.grafana.model.primitives.WorkspaceName.Type
  }
  type AllowedOrganizations = List[AllowedOrganization]
  type AuthenticationProviders =
    List[zio.aws.grafana.model.AuthenticationProviderTypes]
  type DataSourceTypesList = List[zio.aws.grafana.model.DataSourceType]
  type NotificationDestinationsList =
    List[zio.aws.grafana.model.NotificationDestinationType]
  type OrganizationalUnitList = List[OrganizationalUnit]
  type PermissionEntryList = List[zio.aws.grafana.model.PermissionEntry]
  type RoleValueList = List[RoleValue]
  type UpdateErrorList = List[zio.aws.grafana.model.UpdateError]
  type UpdateInstructionBatch = List[zio.aws.grafana.model.UpdateInstruction]
  type UserList = List[zio.aws.grafana.model.User]
  type WorkspaceList = List[zio.aws.grafana.model.WorkspaceSummary]
}
