package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthenticationSummary(
    providers: Iterable[zio.aws.grafana.model.AuthenticationProviderTypes],
    samlConfigurationStatus: Option[
      zio.aws.grafana.model.SamlConfigurationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AuthenticationSummary = {
    import AuthenticationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AuthenticationSummary
      .builder()
      .providersWithStrings(providers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(samlConfigurationStatus.map(value => value.unwrap))(
        _.samlConfigurationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.AuthenticationSummary.ReadOnly =
    zio.aws.grafana.model.AuthenticationSummary.wrap(buildAwsValue())
}
object AuthenticationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.AuthenticationSummary =
      zio.aws.grafana.model.AuthenticationSummary(
        providers,
        samlConfigurationStatus.map(value => value)
      )
    def providers: List[zio.aws.grafana.model.AuthenticationProviderTypes]
    def samlConfigurationStatus
        : Option[zio.aws.grafana.model.SamlConfigurationStatus]
    def getProviders: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(providers)
    def getSamlConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.grafana.model.SamlConfigurationStatus] =
      AwsError.unwrapOptionField(
        "samlConfigurationStatus",
        samlConfigurationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ) extends zio.aws.grafana.model.AuthenticationSummary.ReadOnly {
    override val providers
        : List[zio.aws.grafana.model.AuthenticationProviderTypes] = impl
      .providers()
      .asScala
      .map { item =>
        zio.aws.grafana.model.AuthenticationProviderTypes.wrap(item)
      }
      .toList
    override val samlConfigurationStatus
        : Option[zio.aws.grafana.model.SamlConfigurationStatus] = scala
      .Option(impl.samlConfigurationStatus())
      .map(value => zio.aws.grafana.model.SamlConfigurationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ): zio.aws.grafana.model.AuthenticationSummary.ReadOnly = new Wrapper(impl)
}
