package zio.aws.grafana
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient
import zio.aws.grafana.model.{
  CreateWorkspaceRequest,
  DescribeWorkspaceAuthenticationRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  DescribeWorkspaceRequest,
  AssociateLicenseRequest,
  UpdateWorkspaceAuthenticationRequest,
  UpdatePermissionsRequest,
  ListPermissionsRequest,
  DisassociateLicenseRequest,
  UpdateWorkspaceRequest
}
import zio.aws.grafana.model.AssociateLicenseResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object GrafanaMock extends Mock[Grafana] {
  object DescribeWorkspace
      extends Effect[
        DescribeWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
      ]
  object DisassociateLicense
      extends Effect[
        DisassociateLicenseRequest,
        AwsError,
        zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
      ]
  object UpdatePermissions
      extends Effect[
        UpdatePermissionsRequest,
        AwsError,
        zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
      ]
  object CreateWorkspace
      extends Effect[
        CreateWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
      ]
  object UpdateWorkspaceAuthentication
      extends Effect[
        UpdateWorkspaceAuthenticationRequest,
        AwsError,
        zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
      ]
  object ListWorkspaces
      extends Stream[
        ListWorkspacesRequest,
        AwsError,
        zio.aws.grafana.model.WorkspaceSummary.ReadOnly
      ]
  object ListWorkspacesPaginated
      extends Effect[
        ListWorkspacesRequest,
        AwsError,
        zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
      ]
  object AssociateLicense
      extends Effect[AssociateLicenseRequest, AwsError, ReadOnly]
  object ListPermissions
      extends Stream[
        ListPermissionsRequest,
        AwsError,
        zio.aws.grafana.model.PermissionEntry.ReadOnly
      ]
  object ListPermissionsPaginated
      extends Effect[
        ListPermissionsRequest,
        AwsError,
        zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
      ]
  object DeleteWorkspace
      extends Effect[
        DeleteWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
      ]
  object DescribeWorkspaceAuthentication
      extends Effect[
        DescribeWorkspaceAuthenticationRequest,
        AwsError,
        zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
      ]
  object UpdateWorkspace
      extends Effect[
        UpdateWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Grafana] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Grafana {
          val api: GrafanaAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Grafana = this
          def describeWorkspace(request: DescribeWorkspaceRequest): IO[
            AwsError,
            zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
          ] = proxy(DescribeWorkspace, request)
          def disassociateLicense(request: DisassociateLicenseRequest): IO[
            AwsError,
            zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
          ] = proxy(DisassociateLicense, request)
          def updatePermissions(request: UpdatePermissionsRequest): IO[
            AwsError,
            zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
          ] = proxy(UpdatePermissions, request)
          def createWorkspace(request: CreateWorkspaceRequest): IO[
            AwsError,
            zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
          ] = proxy(CreateWorkspace, request)
          def updateWorkspaceAuthentication(
              request: UpdateWorkspaceAuthenticationRequest
          ): IO[
            AwsError,
            zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
          ] = proxy(UpdateWorkspaceAuthentication, request)
          def listWorkspaces(request: ListWorkspacesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.grafana.model.WorkspaceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorkspaces, request))
          def listWorkspacesPaginated(request: ListWorkspacesRequest): IO[
            AwsError,
            zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
          ] = proxy(ListWorkspacesPaginated, request)
          def associateLicense(
              request: AssociateLicenseRequest
          ): IO[AwsError, ReadOnly] = proxy(AssociateLicense, request)
          def listPermissions(request: ListPermissionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.grafana.model.PermissionEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListPermissions, request))
          def listPermissionsPaginated(request: ListPermissionsRequest): IO[
            AwsError,
            zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
          ] = proxy(ListPermissionsPaginated, request)
          def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
            AwsError,
            zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
          ] = proxy(DeleteWorkspace, request)
          def describeWorkspaceAuthentication(
              request: DescribeWorkspaceAuthenticationRequest
          ): IO[
            AwsError,
            zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
          ] = proxy(DescribeWorkspaceAuthentication, request)
          def updateWorkspace(request: UpdateWorkspaceRequest): IO[
            AwsError,
            zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
          ] = proxy(UpdateWorkspace, request)
        }
      }
    }
    .toLayer
}
