package zio.aws.grafana.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  LoginValidityDuration,
  AllowedOrganization
}
import scala.jdk.CollectionConverters.*
final case class SamlConfiguration(
    allowedOrganizations: Option[Iterable[AllowedOrganization]] = None,
    assertionAttributes: Option[zio.aws.grafana.model.AssertionAttributes] =
      None,
    idpMetadata: zio.aws.grafana.model.IdpMetadata,
    loginValidityDuration: Option[LoginValidityDuration] = None,
    roleValues: Option[zio.aws.grafana.model.RoleValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.SamlConfiguration = {
    import SamlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
      .builder()
      .optionallyWith(
        allowedOrganizations.map(value =>
          value.map { item =>
            AllowedOrganization.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedOrganizations)
      .optionallyWith(assertionAttributes.map(value => value.buildAwsValue()))(
        _.assertionAttributes
      )
      .idpMetadata(idpMetadata.buildAwsValue())
      .optionallyWith(
        loginValidityDuration.map(value =>
          LoginValidityDuration.unwrap(value): Integer
        )
      )(_.loginValidityDuration)
      .optionallyWith(roleValues.map(value => value.buildAwsValue()))(
        _.roleValues
      )
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.SamlConfiguration.ReadOnly =
    zio.aws.grafana.model.SamlConfiguration.wrap(buildAwsValue())
}
object SamlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.SamlConfiguration =
      zio.aws.grafana.model.SamlConfiguration(
        allowedOrganizations.map(value => value),
        assertionAttributes.map(value => value.asEditable),
        idpMetadata.asEditable,
        loginValidityDuration.map(value => value),
        roleValues.map(value => value.asEditable)
      )
    def allowedOrganizations: Option[List[AllowedOrganization]]
    def assertionAttributes
        : Option[zio.aws.grafana.model.AssertionAttributes.ReadOnly]
    def idpMetadata: zio.aws.grafana.model.IdpMetadata.ReadOnly
    def loginValidityDuration: Option[LoginValidityDuration]
    def roleValues: Option[zio.aws.grafana.model.RoleValues.ReadOnly]
    def getAllowedOrganizations: ZIO[Any, AwsError, List[AllowedOrganization]] =
      AwsError.unwrapOptionField("allowedOrganizations", allowedOrganizations)
    def getAssertionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.grafana.model.AssertionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("assertionAttributes", assertionAttributes)
    def getIdpMetadata
        : ZIO[Any, Nothing, zio.aws.grafana.model.IdpMetadata.ReadOnly] =
      ZIO.succeed(idpMetadata)
    def getLoginValidityDuration: ZIO[Any, AwsError, LoginValidityDuration] =
      AwsError.unwrapOptionField("loginValidityDuration", loginValidityDuration)
    def getRoleValues
        : ZIO[Any, AwsError, zio.aws.grafana.model.RoleValues.ReadOnly] =
      AwsError.unwrapOptionField("roleValues", roleValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ) extends zio.aws.grafana.model.SamlConfiguration.ReadOnly {
    override val allowedOrganizations: Option[List[AllowedOrganization]] = scala
      .Option(impl.allowedOrganizations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.AllowedOrganization(item)
        }.toList
      )
    override val assertionAttributes
        : Option[zio.aws.grafana.model.AssertionAttributes.ReadOnly] = scala
      .Option(impl.assertionAttributes())
      .map(value => zio.aws.grafana.model.AssertionAttributes.wrap(value))
    override val idpMetadata: zio.aws.grafana.model.IdpMetadata.ReadOnly =
      zio.aws.grafana.model.IdpMetadata.wrap(impl.idpMetadata())
    override val loginValidityDuration: Option[LoginValidityDuration] = scala
      .Option(impl.loginValidityDuration())
      .map(value =>
        zio.aws.grafana.model.primitives.LoginValidityDuration(value)
      )
    override val roleValues: Option[zio.aws.grafana.model.RoleValues.ReadOnly] =
      scala
        .Option(impl.roleValues())
        .map(value => zio.aws.grafana.model.RoleValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ): zio.aws.grafana.model.SamlConfiguration.ReadOnly = new Wrapper(impl)
}
