package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceAuthenticationResponse(
    authentication: zio.aws.grafana.model.AuthenticationDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse = {
    import UpdateWorkspaceAuthenticationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
      .builder()
      .authentication(authentication.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse
      .wrap(buildAwsValue())
}
object UpdateWorkspaceAuthenticationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse =
      zio.aws.grafana.model
        .UpdateWorkspaceAuthenticationResponse(authentication.asEditable)
    def authentication: zio.aws.grafana.model.AuthenticationDescription.ReadOnly
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.AuthenticationDescription.ReadOnly
    ] = ZIO.succeed(authentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ) extends zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly {
    override val authentication
        : zio.aws.grafana.model.AuthenticationDescription.ReadOnly =
      zio.aws.grafana.model.AuthenticationDescription
        .wrap(impl.authentication())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ): zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly =
    new Wrapper(impl)
}
