package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.RoleValue
import scala.jdk.CollectionConverters.*
final case class RoleValues(
    admin: Option[Iterable[RoleValue]] = None,
    editor: Option[Iterable[RoleValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.RoleValues = {
    import RoleValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.RoleValues
      .builder()
      .optionallyWith(
        admin.map(value =>
          value.map { item =>
            RoleValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.admin)
      .optionallyWith(
        editor.map(value =>
          value.map { item =>
            RoleValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.editor)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.RoleValues.ReadOnly =
    zio.aws.grafana.model.RoleValues.wrap(buildAwsValue())
}
object RoleValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.RoleValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.RoleValues = zio.aws.grafana.model
      .RoleValues(admin.map(value => value), editor.map(value => value))
    def admin: Option[List[RoleValue]]
    def editor: Option[List[RoleValue]]
    def getAdmin: ZIO[Any, AwsError, List[RoleValue]] =
      AwsError.unwrapOptionField("admin", admin)
    def getEditor: ZIO[Any, AwsError, List[RoleValue]] =
      AwsError.unwrapOptionField("editor", editor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.RoleValues
  ) extends zio.aws.grafana.model.RoleValues.ReadOnly {
    override val admin: Option[List[RoleValue]] = scala
      .Option(impl.admin())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.RoleValue(item)
        }.toList
      )
    override val editor: Option[List[RoleValue]] = scala
      .Option(impl.editor())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.RoleValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.RoleValues
  ): zio.aws.grafana.model.RoleValues.ReadOnly = new Wrapper(impl)
}
