package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait UpdateAction {
  def unwrap: software.amazon.awssdk.services.grafana.model.UpdateAction
}
object UpdateAction {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.UpdateAction
  ): zio.aws.grafana.model.UpdateAction = value match {
    case software.amazon.awssdk.services.grafana.model.UpdateAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.UpdateAction.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.grafana.model.UpdateAction.REVOKE =>
      val r = REVOKE
      r
  }
  case object unknownToSdkVersion extends zio.aws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.ADD
  }
  case object REVOKE extends zio.aws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.REVOKE
  }
}
