package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait SamlConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus
}
object SamlConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus
  ): zio.aws.grafana.model.SamlConfigurationStatus = value match {
    case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.CONFIGURED =>
      val r = CONFIGURED
      r
    case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.NOT_CONFIGURED =>
      val r = NOT_CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIGURED extends zio.aws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.CONFIGURED
  }
  case object NOT_CONFIGURED
      extends zio.aws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.NOT_CONFIGURED
  }
}
