package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{VpceId, PrefixListId}
import scala.jdk.CollectionConverters._
final case class NetworkAccessConfiguration(
    prefixListIds: Iterable[PrefixListId],
    vpceIds: Iterable[VpceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration = {
    import NetworkAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration
      .builder()
      .prefixListIds(prefixListIds.map { item =>
        PrefixListId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpceIds(vpceIds.map { item =>
        VpceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly =
    zio.aws.grafana.model.NetworkAccessConfiguration.wrap(buildAwsValue())
}
object NetworkAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.NetworkAccessConfiguration =
      zio.aws.grafana.model.NetworkAccessConfiguration(prefixListIds, vpceIds)
    def prefixListIds: List[PrefixListId]
    def vpceIds: List[VpceId]
    def getPrefixListIds: ZIO[Any, Nothing, List[PrefixListId]] =
      ZIO.succeed(prefixListIds)
    def getVpceIds: ZIO[Any, Nothing, List[VpceId]] = ZIO.succeed(vpceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration
  ) extends zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly {
    override val prefixListIds: List[PrefixListId] = impl
      .prefixListIds()
      .asScala
      .map { item =>
        zio.aws.grafana.model.primitives.PrefixListId(item)
      }
      .toList
    override val vpceIds: List[VpceId] = impl
      .vpceIds()
      .asScala
      .map { item =>
        zio.aws.grafana.model.primitives.VpceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration
  ): zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
