package zio.aws.grafana.model
import zio.prelude.data.Optional
import zio.aws.grafana.model.primitives.{
  LoginValidityDuration,
  AllowedOrganization
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SamlConfiguration(
    allowedOrganizations: Optional[Iterable[AllowedOrganization]] =
      Optional.Absent,
    assertionAttributes: Optional[zio.aws.grafana.model.AssertionAttributes] =
      Optional.Absent,
    idpMetadata: zio.aws.grafana.model.IdpMetadata,
    loginValidityDuration: Optional[LoginValidityDuration] = Optional.Absent,
    roleValues: Optional[zio.aws.grafana.model.RoleValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.SamlConfiguration = {
    import SamlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
      .builder()
      .optionallyWith(
        allowedOrganizations.map(value =>
          value.map { item =>
            AllowedOrganization.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedOrganizations)
      .optionallyWith(assertionAttributes.map(value => value.buildAwsValue()))(
        _.assertionAttributes
      )
      .idpMetadata(idpMetadata.buildAwsValue())
      .optionallyWith(
        loginValidityDuration.map(value =>
          LoginValidityDuration.unwrap(value): Integer
        )
      )(_.loginValidityDuration)
      .optionallyWith(roleValues.map(value => value.buildAwsValue()))(
        _.roleValues
      )
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.SamlConfiguration.ReadOnly =
    zio.aws.grafana.model.SamlConfiguration.wrap(buildAwsValue())
}
object SamlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.SamlConfiguration =
      zio.aws.grafana.model.SamlConfiguration(
        allowedOrganizations.map(value => value),
        assertionAttributes.map(value => value.asEditable),
        idpMetadata.asEditable,
        loginValidityDuration.map(value => value),
        roleValues.map(value => value.asEditable)
      )
    def allowedOrganizations: Optional[List[AllowedOrganization]]
    def assertionAttributes
        : Optional[zio.aws.grafana.model.AssertionAttributes.ReadOnly]
    def idpMetadata: zio.aws.grafana.model.IdpMetadata.ReadOnly
    def loginValidityDuration: Optional[LoginValidityDuration]
    def roleValues: Optional[zio.aws.grafana.model.RoleValues.ReadOnly]
    def getAllowedOrganizations: ZIO[Any, AwsError, List[AllowedOrganization]] =
      AwsError.unwrapOptionField("allowedOrganizations", allowedOrganizations)
    def getAssertionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.grafana.model.AssertionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("assertionAttributes", assertionAttributes)
    def getIdpMetadata
        : ZIO[Any, Nothing, zio.aws.grafana.model.IdpMetadata.ReadOnly] =
      ZIO.succeed(idpMetadata)
    def getLoginValidityDuration: ZIO[Any, AwsError, LoginValidityDuration] =
      AwsError.unwrapOptionField("loginValidityDuration", loginValidityDuration)
    def getRoleValues
        : ZIO[Any, AwsError, zio.aws.grafana.model.RoleValues.ReadOnly] =
      AwsError.unwrapOptionField("roleValues", roleValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ) extends zio.aws.grafana.model.SamlConfiguration.ReadOnly {
    override val allowedOrganizations: Optional[List[AllowedOrganization]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedOrganizations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.primitives.AllowedOrganization(item)
          }.toList
        )
    override val assertionAttributes
        : Optional[zio.aws.grafana.model.AssertionAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assertionAttributes())
        .map(value => zio.aws.grafana.model.AssertionAttributes.wrap(value))
    override val idpMetadata: zio.aws.grafana.model.IdpMetadata.ReadOnly =
      zio.aws.grafana.model.IdpMetadata.wrap(impl.idpMetadata())
    override val loginValidityDuration: Optional[LoginValidityDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loginValidityDuration())
        .map(value =>
          zio.aws.grafana.model.primitives.LoginValidityDuration(value)
        )
    override val roleValues
        : Optional[zio.aws.grafana.model.RoleValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleValues())
        .map(value => zio.aws.grafana.model.RoleValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ): zio.aws.grafana.model.SamlConfiguration.ReadOnly = new Wrapper(impl)
}
