package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{PaginationToken, GrafanaVersion}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVersionsResponse(
    grafanaVersions: Optional[Iterable[GrafanaVersion]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListVersionsResponse = {
    import ListVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListVersionsResponse
      .builder()
      .optionallyWith(
        grafanaVersions.map(value =>
          value.map { item =>
            GrafanaVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grafanaVersions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListVersionsResponse.ReadOnly =
    zio.aws.grafana.model.ListVersionsResponse.wrap(buildAwsValue())
}
object ListVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListVersionsResponse =
      zio.aws.grafana.model.ListVersionsResponse(
        grafanaVersions.map(value => value),
        nextToken.map(value => value)
      )
    def grafanaVersions: Optional[List[GrafanaVersion]]
    def nextToken: Optional[PaginationToken]
    def getGrafanaVersions: ZIO[Any, AwsError, List[GrafanaVersion]] =
      AwsError.unwrapOptionField("grafanaVersions", grafanaVersions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListVersionsResponse
  ) extends zio.aws.grafana.model.ListVersionsResponse.ReadOnly {
    override val grafanaVersions: Optional[List[GrafanaVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grafanaVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.primitives.GrafanaVersion(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListVersionsResponse
  ): zio.aws.grafana.model.ListVersionsResponse.ReadOnly = new Wrapper(impl)
}
