package zio.aws.grafana.model
import zio.prelude.data.Optional
import zio.aws.grafana.model.primitives.{
  PaginationToken,
  ListWorkspacesRequestMaxResultsInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkspacesRequest(
    maxResults: Optional[ListWorkspacesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest = {
    import ListWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListWorkspacesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly =
    zio.aws.grafana.model.ListWorkspacesRequest.wrap(buildAwsValue())
}
object ListWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListWorkspacesRequest =
      zio.aws.grafana.model.ListWorkspacesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListWorkspacesRequestMaxResultsInteger]
    def nextToken: Optional[PaginationToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListWorkspacesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ) extends zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly {
    override val maxResults: Optional[ListWorkspacesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.grafana.model.primitives
            .ListWorkspacesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ): zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly = new Wrapper(impl)
}
