package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceConfigurationRequest(
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest = {
    import DescribeWorkspaceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest =
      zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest
  ) extends zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest
  ): zio.aws.grafana.model.DescribeWorkspaceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
