package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait LicenseType {
  def unwrap: software.amazon.awssdk.services.grafana.model.LicenseType
}
object LicenseType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.LicenseType
  ): zio.aws.grafana.model.LicenseType = value match {
    case software.amazon.awssdk.services.grafana.model.LicenseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.LicenseType.ENTERPRISE =>
      val r = ENTERPRISE
      r
    case software.amazon.awssdk.services.grafana.model.LicenseType.ENTERPRISE_FREE_TRIAL =>
      val r = ENTERPRISE_FREE_TRIAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.grafana.model.LicenseType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.LicenseType =
      software.amazon.awssdk.services.grafana.model.LicenseType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENTERPRISE extends zio.aws.grafana.model.LicenseType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.LicenseType =
      software.amazon.awssdk.services.grafana.model.LicenseType.ENTERPRISE
  }
  case object ENTERPRISE_FREE_TRIAL extends zio.aws.grafana.model.LicenseType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.LicenseType =
      software.amazon.awssdk.services.grafana.model.LicenseType.ENTERPRISE_FREE_TRIAL
  }
}
