package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{SubnetId, SecurityGroupId}
import scala.jdk.CollectionConverters._
final case class VpcConfiguration(
    securityGroupIds: Iterable[SecurityGroupId],
    subnetIds: Iterable[SubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.VpcConfiguration
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.VpcConfiguration.ReadOnly =
    zio.aws.grafana.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.VpcConfiguration =
      zio.aws.grafana.model.VpcConfiguration(securityGroupIds, subnetIds)
    def securityGroupIds: List[SecurityGroupId]
    def subnetIds: List[SubnetId]
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.VpcConfiguration
  ) extends zio.aws.grafana.model.VpcConfiguration.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.grafana.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.grafana.model.primitives.SubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.VpcConfiguration
  ): zio.aws.grafana.model.VpcConfiguration.ReadOnly = new Wrapper(impl)
}
