package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait Role {
  def unwrap: software.amazon.awssdk.services.grafana.model.Role
}
object Role {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.Role
  ): zio.aws.grafana.model.Role = value match {
    case software.amazon.awssdk.services.grafana.model.Role.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.Role.ADMIN =>
      val r = ADMIN
      r
    case software.amazon.awssdk.services.grafana.model.Role.EDITOR =>
      val r = EDITOR
      r
    case software.amazon.awssdk.services.grafana.model.Role.VIEWER =>
      val r = VIEWER
      r
  }
  case object unknownToSdkVersion extends zio.aws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.UNKNOWN_TO_SDK_VERSION
  }
  case object ADMIN extends zio.aws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.ADMIN
  }
  case object EDITOR extends zio.aws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.EDITOR
  }
  case object VIEWER extends zio.aws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.VIEWER
  }
}
