package zio.aws.grafana
import software.amazon.awssdk.services.grafana.{
  GrafanaAsyncClientBuilder,
  GrafanaAsyncClient
}
import zio.aws.grafana.model.{
  CreateWorkspaceRequest,
  DescribeWorkspaceAuthenticationRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  CreateWorkspaceApiKeyRequest,
  DescribeWorkspaceRequest,
  DeleteWorkspaceApiKeyRequest,
  UpdateWorkspaceConfigurationRequest,
  ListTagsForResourceRequest,
  AssociateLicenseRequest,
  UpdateWorkspaceAuthenticationRequest,
  UpdatePermissionsRequest,
  ListPermissionsRequest,
  UntagResourceRequest,
  DescribeWorkspaceConfigurationRequest,
  DisassociateLicenseRequest,
  UpdateWorkspaceRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.grafana.model.AssociateLicenseResponse.ReadOnly
import software.amazon.awssdk.services.grafana.paginators.{
  ListPermissionsPublisher,
  ListWorkspacesPublisher
}
import software.amazon.awssdk.services.grafana.model.{
  PermissionEntry,
  CreateWorkspaceResponse,
  UpdateWorkspaceAuthenticationResponse,
  DescribeWorkspaceResponse,
  WorkspaceSummary,
  UpdateWorkspaceConfigurationResponse,
  DeleteWorkspaceResponse,
  ListWorkspacesResponse,
  ListTagsForResourceResponse,
  ListPermissionsResponse,
  DeleteWorkspaceApiKeyResponse,
  UntagResourceResponse,
  AssociateLicenseResponse,
  DescribeWorkspaceConfigurationResponse,
  DescribeWorkspaceAuthenticationResponse,
  UpdateWorkspaceResponse,
  UpdatePermissionsResponse,
  DisassociateLicenseResponse,
  TagResourceResponse,
  CreateWorkspaceApiKeyResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Grafana extends AspectSupport[Grafana] {
  val api: GrafanaAsyncClient
  def describeWorkspace(
      request: DescribeWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly]
  def disassociateLicense(
      request: DisassociateLicenseRequest
  ): IO[AwsError, zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly]
  def updatePermissions(
      request: UpdatePermissionsRequest
  ): IO[AwsError, zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly]
  def createWorkspace(
      request: CreateWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly]
  def createWorkspaceApiKey(
      request: CreateWorkspaceApiKeyRequest
  ): IO[AwsError, zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly]
  def deleteWorkspaceApiKey(
      request: DeleteWorkspaceApiKeyRequest
  ): IO[AwsError, zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.ReadOnly]
  def updateWorkspaceAuthentication(
      request: UpdateWorkspaceAuthenticationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
  ]
  def updateWorkspaceConfiguration(
      request: UpdateWorkspaceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.ReadOnly
  ]
  def listWorkspaces(
      request: ListWorkspacesRequest
  ): ZStream[Any, AwsError, zio.aws.grafana.model.WorkspaceSummary.ReadOnly]
  def listWorkspacesPaginated(
      request: ListWorkspacesRequest
  ): IO[AwsError, zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly]
  def associateLicense(request: AssociateLicenseRequest): IO[AwsError, ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.grafana.model.UntagResourceResponse.ReadOnly]
  def describeWorkspaceConfiguration(
      request: DescribeWorkspaceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.grafana.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.grafana.model.TagResourceResponse.ReadOnly]
  def listPermissions(
      request: ListPermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.grafana.model.PermissionEntry.ReadOnly]
  def listPermissionsPaginated(
      request: ListPermissionsRequest
  ): IO[AwsError, zio.aws.grafana.model.ListPermissionsResponse.ReadOnly]
  def deleteWorkspace(
      request: DeleteWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly]
  def describeWorkspaceAuthentication(
      request: DescribeWorkspaceAuthenticationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
  ]
  def updateWorkspace(
      request: UpdateWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly]
}
object Grafana {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Grafana] = customized(
    identity
  )
  def customized(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Grafana] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Grafana] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = GrafanaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[GrafanaAsyncClient, GrafanaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[GrafanaAsyncClient, GrafanaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new GrafanaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class GrafanaImpl[R](
      override val api: GrafanaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Grafana
      with AwsServiceBase[R] {
    override val serviceName: String = "Grafana"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GrafanaImpl[R1] = new GrafanaImpl(api, newAspect, r)
    def describeWorkspace(
        request: DescribeWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest,
        DescribeWorkspaceResponse
      ]("describeWorkspace", api.describeWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.DescribeWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def disassociateLicense(request: DisassociateLicenseRequest): IO[
      AwsError,
      zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest,
      DisassociateLicenseResponse
    ]("disassociateLicense", api.disassociateLicense)(request.buildAwsValue())
      .map(zio.aws.grafana.model.DisassociateLicenseResponse.wrap)
      .provideEnvironment(r)
    def updatePermissions(
        request: UpdatePermissionsRequest
    ): IO[AwsError, zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest,
        UpdatePermissionsResponse
      ]("updatePermissions", api.updatePermissions)(request.buildAwsValue())
        .map(zio.aws.grafana.model.UpdatePermissionsResponse.wrap)
        .provideEnvironment(r)
    def createWorkspace(
        request: CreateWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest,
        CreateWorkspaceResponse
      ]("createWorkspace", api.createWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.CreateWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def createWorkspaceApiKey(request: CreateWorkspaceApiKeyRequest): IO[
      AwsError,
      zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest,
      CreateWorkspaceApiKeyResponse
    ]("createWorkspaceApiKey", api.createWorkspaceApiKey)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkspaceApiKey(request: DeleteWorkspaceApiKeyRequest): IO[
      AwsError,
      zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest,
      DeleteWorkspaceApiKeyResponse
    ]("deleteWorkspaceApiKey", api.deleteWorkspaceApiKey)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.wrap)
      .provideEnvironment(r)
    def updateWorkspaceAuthentication(
        request: UpdateWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest,
      UpdateWorkspaceAuthenticationResponse
    ]("updateWorkspaceAuthentication", api.updateWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.wrap)
      .provideEnvironment(r)
    def updateWorkspaceConfiguration(
        request: UpdateWorkspaceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest,
      UpdateWorkspaceConfigurationResponse
    ]("updateWorkspaceConfiguration", api.updateWorkspaceConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listWorkspaces(
        request: ListWorkspacesRequest
    ): ZStream[Any, AwsError, zio.aws.grafana.model.WorkspaceSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest,
        WorkspaceSummary,
        ListWorkspacesPublisher
      ]("listWorkspaces", api.listWorkspacesPaginator, _.workspaces())(
        request.buildAwsValue()
      ).map(item => zio.aws.grafana.model.WorkspaceSummary.wrap(item))
        .provideEnvironment(r)
    def listWorkspacesPaginated(
        request: ListWorkspacesRequest
    ): IO[AwsError, zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest,
        ListWorkspacesResponse
      ]("listWorkspaces", api.listWorkspaces)(request.buildAwsValue())
        .map(zio.aws.grafana.model.ListWorkspacesResponse.wrap)
        .provideEnvironment(r)
    def associateLicense(
        request: AssociateLicenseRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest,
      AssociateLicenseResponse
    ]("associateLicense", api.associateLicense)(request.buildAwsValue())
      .map(zio.aws.grafana.model.AssociateLicenseResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.grafana.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.grafana.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeWorkspaceConfiguration(
        request: DescribeWorkspaceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest,
      DescribeWorkspaceConfigurationResponse
    ]("describeWorkspaceConfiguration", api.describeWorkspaceConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.grafana.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.grafana.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.grafana.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.grafana.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listPermissions(
        request: ListPermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.grafana.model.PermissionEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.grafana.model.ListPermissionsRequest,
        PermissionEntry,
        ListPermissionsPublisher
      ]("listPermissions", api.listPermissionsPaginator, _.permissions())(
        request.buildAwsValue()
      ).map(item => zio.aws.grafana.model.PermissionEntry.wrap(item))
        .provideEnvironment(r)
    def listPermissionsPaginated(
        request: ListPermissionsRequest
    ): IO[AwsError, zio.aws.grafana.model.ListPermissionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.ListPermissionsRequest,
        ListPermissionsResponse
      ]("listPermissions", api.listPermissions)(request.buildAwsValue())
        .map(zio.aws.grafana.model.ListPermissionsResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkspace(
        request: DeleteWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest,
        DeleteWorkspaceResponse
      ]("deleteWorkspace", api.deleteWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.DeleteWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def describeWorkspaceAuthentication(
        request: DescribeWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest,
      DescribeWorkspaceAuthenticationResponse
    ]("describeWorkspaceAuthentication", api.describeWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.wrap)
      .provideEnvironment(r)
    def updateWorkspace(
        request: UpdateWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest,
        UpdateWorkspaceResponse
      ]("updateWorkspace", api.updateWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.UpdateWorkspaceResponse.wrap)
        .provideEnvironment(r)
  }
  def describeWorkspace(request: DescribeWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspace(request))
  def disassociateLicense(request: DisassociateLicenseRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateLicense(request))
  def updatePermissions(request: UpdatePermissionsRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePermissions(request))
  def createWorkspace(request: CreateWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspace(request))
  def createWorkspaceApiKey(request: CreateWorkspaceApiKeyRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspaceApiKey(request))
  def deleteWorkspaceApiKey(request: DeleteWorkspaceApiKeyRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspaceApiKey(request))
  def updateWorkspaceAuthentication(
      request: UpdateWorkspaceAuthenticationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspaceAuthentication(request))
  def updateWorkspaceConfiguration(
      request: UpdateWorkspaceConfigurationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspaceConfiguration(request))
  def listWorkspaces(request: ListWorkspacesRequest): ZStream[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.WorkspaceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkspaces(request))
  def listWorkspacesPaginated(request: ListWorkspacesRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkspacesPaginated(request))
  def associateLicense(
      request: AssociateLicenseRequest
  ): ZIO[zio.aws.grafana.Grafana, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.associateLicense(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeWorkspaceConfiguration(
      request: DescribeWorkspaceConfigurationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceConfiguration(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listPermissions(request: ListPermissionsRequest): ZStream[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.PermissionEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissions(request))
  def listPermissionsPaginated(request: ListPermissionsRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionsPaginated(request))
  def deleteWorkspace(request: DeleteWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspace(request))
  def describeWorkspaceAuthentication(
      request: DescribeWorkspaceAuthenticationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceAuthentication(request))
  def updateWorkspace(request: UpdateWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspace(request))
}
