package zio.aws.grafana
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient
import zio.aws.grafana.model.{
  CreateWorkspaceRequest,
  DescribeWorkspaceAuthenticationRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  CreateWorkspaceApiKeyRequest,
  DescribeWorkspaceRequest,
  DeleteWorkspaceApiKeyRequest,
  UpdateWorkspaceConfigurationRequest,
  ListTagsForResourceRequest,
  ListVersionsRequest,
  AssociateLicenseRequest,
  UpdateWorkspaceAuthenticationRequest,
  UpdatePermissionsRequest,
  ListPermissionsRequest,
  UntagResourceRequest,
  DescribeWorkspaceConfigurationRequest,
  DisassociateLicenseRequest,
  UpdateWorkspaceRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.grafana.model.AssociateLicenseResponse.ReadOnly
import zio.aws.grafana.model.primitives.GrafanaVersion
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object GrafanaMock extends Mock[Grafana] {
  object DescribeWorkspace
      extends Effect[
        DescribeWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
      ]
  object DisassociateLicense
      extends Effect[
        DisassociateLicenseRequest,
        AwsError,
        zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
      ]
  object UpdatePermissions
      extends Effect[
        UpdatePermissionsRequest,
        AwsError,
        zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
      ]
  object CreateWorkspace
      extends Effect[
        CreateWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
      ]
  object CreateWorkspaceApiKey
      extends Effect[
        CreateWorkspaceApiKeyRequest,
        AwsError,
        zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly
      ]
  object DeleteWorkspaceApiKey
      extends Effect[
        DeleteWorkspaceApiKeyRequest,
        AwsError,
        zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.ReadOnly
      ]
  object UpdateWorkspaceAuthentication
      extends Effect[
        UpdateWorkspaceAuthenticationRequest,
        AwsError,
        zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
      ]
  object UpdateWorkspaceConfiguration
      extends Effect[
        UpdateWorkspaceConfigurationRequest,
        AwsError,
        zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.ReadOnly
      ]
  object ListWorkspaces
      extends Stream[
        ListWorkspacesRequest,
        AwsError,
        zio.aws.grafana.model.WorkspaceSummary.ReadOnly
      ]
  object ListWorkspacesPaginated
      extends Effect[
        ListWorkspacesRequest,
        AwsError,
        zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
      ]
  object AssociateLicense
      extends Effect[AssociateLicenseRequest, AwsError, ReadOnly]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.grafana.model.UntagResourceResponse.ReadOnly
      ]
  object ListVersions
      extends Stream[ListVersionsRequest, AwsError, GrafanaVersion]
  object ListVersionsPaginated
      extends Effect[
        ListVersionsRequest,
        AwsError,
        zio.aws.grafana.model.ListVersionsResponse.ReadOnly
      ]
  object DescribeWorkspaceConfiguration
      extends Effect[
        DescribeWorkspaceConfigurationRequest,
        AwsError,
        zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.grafana.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.grafana.model.TagResourceResponse.ReadOnly
      ]
  object ListPermissions
      extends Stream[
        ListPermissionsRequest,
        AwsError,
        zio.aws.grafana.model.PermissionEntry.ReadOnly
      ]
  object ListPermissionsPaginated
      extends Effect[
        ListPermissionsRequest,
        AwsError,
        zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
      ]
  object DeleteWorkspace
      extends Effect[
        DeleteWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
      ]
  object DescribeWorkspaceAuthentication
      extends Effect[
        DescribeWorkspaceAuthenticationRequest,
        AwsError,
        zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
      ]
  object UpdateWorkspace
      extends Effect[
        UpdateWorkspaceRequest,
        AwsError,
        zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Grafana] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Grafana] { rts =>
        zio.ZIO.succeed {
          new Grafana {
            val api: GrafanaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Grafana = this
            def describeWorkspace(request: DescribeWorkspaceRequest): IO[
              AwsError,
              zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
            ] = proxy(DescribeWorkspace, request)
            def disassociateLicense(request: DisassociateLicenseRequest): IO[
              AwsError,
              zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
            ] = proxy(DisassociateLicense, request)
            def updatePermissions(request: UpdatePermissionsRequest): IO[
              AwsError,
              zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
            ] = proxy(UpdatePermissions, request)
            def createWorkspace(request: CreateWorkspaceRequest): IO[
              AwsError,
              zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
            ] = proxy(CreateWorkspace, request)
            def createWorkspaceApiKey(
                request: CreateWorkspaceApiKeyRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly
            ] = proxy(CreateWorkspaceApiKey, request)
            def deleteWorkspaceApiKey(
                request: DeleteWorkspaceApiKeyRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.DeleteWorkspaceApiKeyResponse.ReadOnly
            ] = proxy(DeleteWorkspaceApiKey, request)
            def updateWorkspaceAuthentication(
                request: UpdateWorkspaceAuthenticationRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
            ] = proxy(UpdateWorkspaceAuthentication, request)
            def updateWorkspaceConfiguration(
                request: UpdateWorkspaceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.UpdateWorkspaceConfigurationResponse.ReadOnly
            ] = proxy(UpdateWorkspaceConfiguration, request)
            def listWorkspaces(request: ListWorkspacesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.grafana.model.WorkspaceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkspaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkspacesPaginated(request: ListWorkspacesRequest): IO[
              AwsError,
              zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
            ] = proxy(ListWorkspacesPaginated, request)
            def associateLicense(
                request: AssociateLicenseRequest
            ): IO[AwsError, ReadOnly] = proxy(AssociateLicense, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.grafana.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listVersions(
                request: ListVersionsRequest
            ): ZStream[Any, AwsError, GrafanaVersion] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListVersions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listVersionsPaginated(request: ListVersionsRequest): IO[
              AwsError,
              zio.aws.grafana.model.ListVersionsResponse.ReadOnly
            ] = proxy(ListVersionsPaginated, request)
            def describeWorkspaceConfiguration(
                request: DescribeWorkspaceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly
            ] = proxy(DescribeWorkspaceConfiguration, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.grafana.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.grafana.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listPermissions(request: ListPermissionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.grafana.model.PermissionEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPermissions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPermissionsPaginated(request: ListPermissionsRequest): IO[
              AwsError,
              zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
            ] = proxy(ListPermissionsPaginated, request)
            def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
              AwsError,
              zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
            ] = proxy(DeleteWorkspace, request)
            def describeWorkspaceAuthentication(
                request: DescribeWorkspaceAuthenticationRequest
            ): IO[
              AwsError,
              zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
            ] = proxy(DescribeWorkspaceAuthentication, request)
            def updateWorkspace(request: UpdateWorkspaceRequest): IO[
              AwsError,
              zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
            ] = proxy(UpdateWorkspace, request)
          }
        }
      }
    }
  }
}
