package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters._
final case class UpdatePermissionsRequest(
    updateInstructionBatch: Iterable[zio.aws.grafana.model.UpdateInstruction],
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest = {
    import UpdatePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
      .builder()
      .updateInstructionBatch(updateInstructionBatch.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdatePermissionsRequest.ReadOnly =
    zio.aws.grafana.model.UpdatePermissionsRequest.wrap(buildAwsValue())
}
object UpdatePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdatePermissionsRequest =
      zio.aws.grafana.model.UpdatePermissionsRequest(
        updateInstructionBatch.map { item =>
          item.asEditable
        },
        workspaceId
      )
    def updateInstructionBatch
        : List[zio.aws.grafana.model.UpdateInstruction.ReadOnly]
    def workspaceId: WorkspaceId
    def getUpdateInstructionBatch: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.UpdateInstruction.ReadOnly
    ]] = ZIO.succeed(updateInstructionBatch)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ) extends zio.aws.grafana.model.UpdatePermissionsRequest.ReadOnly {
    override val updateInstructionBatch
        : List[zio.aws.grafana.model.UpdateInstruction.ReadOnly] = impl
      .updateInstructionBatch()
      .asScala
      .map { item =>
        zio.aws.grafana.model.UpdateInstruction.wrap(item)
      }
      .toList
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ): zio.aws.grafana.model.UpdatePermissionsRequest.ReadOnly = new Wrapper(impl)
}
