package zio.aws.grafana.model
import zio.prelude.data.Optional
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  PaginationToken,
  ListPermissionsRequestMaxResultsInteger,
  SsoId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    groupId: Optional[SsoId] = Optional.Absent,
    maxResults: Optional[ListPermissionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    userId: Optional[SsoId] = Optional.Absent,
    userType: Optional[zio.aws.grafana.model.UserType] = Optional.Absent,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
      .builder()
      .optionallyWith(
        groupId.map(value => SsoId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        maxResults.map(value =>
          ListPermissionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        userId.map(value => SsoId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListPermissionsRequest.ReadOnly =
    zio.aws.grafana.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListPermissionsRequest =
      zio.aws.grafana.model.ListPermissionsRequest(
        groupId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        userId.map(value => value),
        userType.map(value => value),
        workspaceId
      )
    def groupId: Optional[SsoId]
    def maxResults: Optional[ListPermissionsRequestMaxResultsInteger]
    def nextToken: Optional[PaginationToken]
    def userId: Optional[SsoId]
    def userType: Optional[zio.aws.grafana.model.UserType]
    def workspaceId: WorkspaceId
    def getGroupId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getMaxResults
        : ZIO[Any, AwsError, ListPermissionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserType: ZIO[Any, AwsError, zio.aws.grafana.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ) extends zio.aws.grafana.model.ListPermissionsRequest.ReadOnly {
    override val groupId: Optional[SsoId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.grafana.model.primitives.SsoId(value))
    override val maxResults: Optional[ListPermissionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.grafana.model.primitives
            .ListPermissionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
    override val userId: Optional[SsoId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.grafana.model.primitives.SsoId(value))
    override val userType: Optional[zio.aws.grafana.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.grafana.model.UserType.wrap(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ): zio.aws.grafana.model.ListPermissionsRequest.ReadOnly = new Wrapper(impl)
}
