package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.OverridableConfigurationJson
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceConfigurationResponse(
    configuration: OverridableConfigurationJson
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse = {
    import DescribeWorkspaceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
      .builder()
      .configuration(
        OverridableConfigurationJson.unwrap(configuration): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse =
      zio.aws.grafana.model
        .DescribeWorkspaceConfigurationResponse(configuration)
    def configuration: OverridableConfigurationJson
    def getConfiguration: ZIO[Any, Nothing, OverridableConfigurationJson] =
      ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ) extends zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly {
    override val configuration: OverridableConfigurationJson =
      zio.aws.grafana.model.primitives
        .OverridableConfigurationJson(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ): zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
