package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateInstruction(
    action: zio.aws.grafana.model.UpdateAction,
    role: zio.aws.grafana.model.Role,
    users: Iterable[zio.aws.grafana.model.User]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateInstruction = {
    import UpdateInstruction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateInstruction
      .builder()
      .action(action.unwrap)
      .role(role.unwrap)
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdateInstruction.ReadOnly =
    zio.aws.grafana.model.UpdateInstruction.wrap(buildAwsValue())
}
object UpdateInstruction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateInstruction =
      zio.aws.grafana.model.UpdateInstruction(
        action,
        role,
        users.map { item =>
          item.asEditable
        }
      )
    def action: zio.aws.grafana.model.UpdateAction
    def role: zio.aws.grafana.model.Role
    def users: List[zio.aws.grafana.model.User.ReadOnly]
    def getAction: ZIO[Any, Nothing, zio.aws.grafana.model.UpdateAction] =
      ZIO.succeed(action)
    def getRole: ZIO[Any, Nothing, zio.aws.grafana.model.Role] =
      ZIO.succeed(role)
    def getUsers: ZIO[Any, Nothing, List[zio.aws.grafana.model.User.ReadOnly]] =
      ZIO.succeed(users)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ) extends zio.aws.grafana.model.UpdateInstruction.ReadOnly {
    override val action: zio.aws.grafana.model.UpdateAction =
      zio.aws.grafana.model.UpdateAction.wrap(impl.action())
    override val role: zio.aws.grafana.model.Role =
      zio.aws.grafana.model.Role.wrap(impl.role())
    override val users: List[zio.aws.grafana.model.User.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        zio.aws.grafana.model.User.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ): zio.aws.grafana.model.UpdateInstruction.ReadOnly = new Wrapper(impl)
}
