package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters._
final case class DeleteWorkspaceRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest = {
    import DeleteWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.DeleteWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.DeleteWorkspaceRequest.wrap(buildAwsValue())
}
object DeleteWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.DeleteWorkspaceRequest =
      zio.aws.grafana.model.DeleteWorkspaceRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ) extends zio.aws.grafana.model.DeleteWorkspaceRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ): zio.aws.grafana.model.DeleteWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
