package zio.aws.grafana.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  CreateWorkspaceApiKeyRequestSecondsToLiveInteger,
  ApiKeyName
}
import scala.jdk.CollectionConverters._
final case class CreateWorkspaceApiKeyRequest(
    keyName: ApiKeyName,
    keyRole: String,
    secondsToLive: CreateWorkspaceApiKeyRequestSecondsToLiveInteger,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest = {
    import CreateWorkspaceApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest
      .builder()
      .keyName(ApiKeyName.unwrap(keyName): java.lang.String)
      .keyRole(keyRole: java.lang.String)
      .secondsToLive(
        CreateWorkspaceApiKeyRequestSecondsToLiveInteger.unwrap(
          secondsToLive
        ): Integer
      )
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.CreateWorkspaceApiKeyRequest.ReadOnly =
    zio.aws.grafana.model.CreateWorkspaceApiKeyRequest.wrap(buildAwsValue())
}
object CreateWorkspaceApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.CreateWorkspaceApiKeyRequest =
      zio.aws.grafana.model.CreateWorkspaceApiKeyRequest(
        keyName,
        keyRole,
        secondsToLive,
        workspaceId
      )
    def keyName: ApiKeyName
    def keyRole: String
    def secondsToLive: CreateWorkspaceApiKeyRequestSecondsToLiveInteger
    def workspaceId: WorkspaceId
    def getKeyName: ZIO[Any, Nothing, ApiKeyName] = ZIO.succeed(keyName)
    def getKeyRole: ZIO[Any, Nothing, String] = ZIO.succeed(keyRole)
    def getSecondsToLive
        : ZIO[Any, Nothing, CreateWorkspaceApiKeyRequestSecondsToLiveInteger] =
      ZIO.succeed(secondsToLive)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest
  ) extends zio.aws.grafana.model.CreateWorkspaceApiKeyRequest.ReadOnly {
    override val keyName: ApiKeyName =
      zio.aws.grafana.model.primitives.ApiKeyName(impl.keyName())
    override val keyRole: String = impl.keyRole(): String
    override val secondsToLive
        : CreateWorkspaceApiKeyRequestSecondsToLiveInteger =
      zio.aws.grafana.model.primitives
        .CreateWorkspaceApiKeyRequestSecondsToLiveInteger(impl.secondsToLive())
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest
  ): zio.aws.grafana.model.CreateWorkspaceApiKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
