package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{WorkspaceId, ApiKeyName}
import scala.jdk.CollectionConverters._
final case class DeleteWorkspaceApiKeyRequest(
    keyName: ApiKeyName,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest = {
    import DeleteWorkspaceApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest
      .builder()
      .keyName(ApiKeyName.unwrap(keyName): java.lang.String)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest.ReadOnly =
    zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest.wrap(buildAwsValue())
}
object DeleteWorkspaceApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest =
      zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest(keyName, workspaceId)
    def keyName: ApiKeyName
    def workspaceId: WorkspaceId
    def getKeyName: ZIO[Any, Nothing, ApiKeyName] = ZIO.succeed(keyName)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest
  ) extends zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest.ReadOnly {
    override val keyName: ApiKeyName =
      zio.aws.grafana.model.primitives.ApiKeyName(impl.keyName())
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest
  ): zio.aws.grafana.model.DeleteWorkspaceApiKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
