package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateWorkspaceResponse(
    workspace: zio.aws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse = {
    import UpdateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceResponse.wrap(buildAwsValue())
}
object UpdateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceResponse =
      zio.aws.grafana.model.UpdateWorkspaceResponse(workspace.asEditable)
    def workspace: zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    def getWorkspace: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ) extends zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly {
    override val workspace
        : zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
      zio.aws.grafana.model.WorkspaceDescription.wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ): zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly = new Wrapper(impl)
}
