package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PermissionEntry(
    role: zio.aws.grafana.model.Role,
    user: zio.aws.grafana.model.User
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.PermissionEntry = {
    import PermissionEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.PermissionEntry
      .builder()
      .role(role.unwrap)
      .user(user.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.PermissionEntry.ReadOnly =
    zio.aws.grafana.model.PermissionEntry.wrap(buildAwsValue())
}
object PermissionEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.PermissionEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.PermissionEntry =
      zio.aws.grafana.model.PermissionEntry(role, user.asEditable)
    def role: zio.aws.grafana.model.Role
    def user: zio.aws.grafana.model.User.ReadOnly
    def getRole: ZIO[Any, Nothing, zio.aws.grafana.model.Role] =
      ZIO.succeed(role)
    def getUser: ZIO[Any, Nothing, zio.aws.grafana.model.User.ReadOnly] =
      ZIO.succeed(user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.PermissionEntry
  ) extends zio.aws.grafana.model.PermissionEntry.ReadOnly {
    override val role: zio.aws.grafana.model.Role =
      zio.aws.grafana.model.Role.wrap(impl.role())
    override val user: zio.aws.grafana.model.User.ReadOnly =
      zio.aws.grafana.model.User.wrap(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.PermissionEntry
  ): zio.aws.grafana.model.PermissionEntry.ReadOnly = new Wrapper(impl)
}
