package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{WorkspaceId, ApiKeyName, ApiKeyToken}
import scala.jdk.CollectionConverters._
final case class CreateWorkspaceApiKeyResponse(
    key: ApiKeyToken,
    keyName: ApiKeyName,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse = {
    import CreateWorkspaceApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse
      .builder()
      .key(ApiKeyToken.unwrap(key): java.lang.String)
      .keyName(ApiKeyName.unwrap(keyName): java.lang.String)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly =
    zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.wrap(buildAwsValue())
}
object CreateWorkspaceApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.CreateWorkspaceApiKeyResponse =
      zio.aws.grafana.model
        .CreateWorkspaceApiKeyResponse(key, keyName, workspaceId)
    def key: ApiKeyToken
    def keyName: ApiKeyName
    def workspaceId: WorkspaceId
    def getKey: ZIO[Any, Nothing, ApiKeyToken] = ZIO.succeed(key)
    def getKeyName: ZIO[Any, Nothing, ApiKeyName] = ZIO.succeed(keyName)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse
  ) extends zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly {
    override val key: ApiKeyToken =
      zio.aws.grafana.model.primitives.ApiKeyToken(impl.key())
    override val keyName: ApiKeyName =
      zio.aws.grafana.model.primitives.ApiKeyName(impl.keyName())
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse
  ): zio.aws.grafana.model.CreateWorkspaceApiKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
