package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait WorkspaceStatus {
  def unwrap: software.amazon.awssdk.services.grafana.model.WorkspaceStatus
}
object WorkspaceStatus {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.WorkspaceStatus
  ): zio.aws.grafana.model.WorkspaceStatus = value match {
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPGRADING =>
      val r = UPGRADING
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.DELETION_FAILED =>
      val r = DELETION_FAILED
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.CREATION_FAILED =>
      val r = CREATION_FAILED
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPGRADE_FAILED =>
      val r = UPGRADE_FAILED
      r
    case software.amazon.awssdk.services.grafana.model.WorkspaceStatus.LICENSE_REMOVAL_FAILED =>
      val r = LICENSE_REMOVAL_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.ACTIVE
  }
  case object CREATING extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.CREATING
  }
  case object DELETING extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.DELETING
  }
  case object FAILED extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.FAILED
  }
  case object UPDATING extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPDATING
  }
  case object UPGRADING extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPGRADING
  }
  case object DELETION_FAILED extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.DELETION_FAILED
  }
  case object CREATION_FAILED extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.CREATION_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPDATE_FAILED
  }
  case object UPGRADE_FAILED extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.UPGRADE_FAILED
  }
  case object LICENSE_REMOVAL_FAILED
      extends zio.aws.grafana.model.WorkspaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.WorkspaceStatus =
      software.amazon.awssdk.services.grafana.model.WorkspaceStatus.LICENSE_REMOVAL_FAILED
  }
}
