package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.SSOClientId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSsoAuthentication(
    ssoClientId: Optional[SSOClientId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication = {
    import AwsSsoAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
      .builder()
      .optionallyWith(
        ssoClientId.map(value => SSOClientId.unwrap(value): java.lang.String)
      )(_.ssoClientId)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly =
    zio.aws.grafana.model.AwsSsoAuthentication.wrap(buildAwsValue())
}
object AwsSsoAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.AwsSsoAuthentication =
      zio.aws.grafana.model
        .AwsSsoAuthentication(ssoClientId.map(value => value))
    def ssoClientId: Optional[SSOClientId]
    def getSsoClientId: ZIO[Any, AwsError, SSOClientId] =
      AwsError.unwrapOptionField("ssoClientId", ssoClientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ) extends zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly {
    override val ssoClientId: Optional[SSOClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssoClientId())
      .map(value => zio.aws.grafana.model.primitives.SSOClientId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ): zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly = new Wrapper(impl)
}
