package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.IdpMetadataUrl
import scala.jdk.CollectionConverters._
final case class IdpMetadata(
    url: Option[IdpMetadataUrl] = None,
    xml: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.IdpMetadata = {
    import IdpMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.IdpMetadata
      .builder()
      .optionallyWith(
        url.map(value => IdpMetadataUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(xml.map(value => value: java.lang.String))(_.xml)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.IdpMetadata.ReadOnly =
    zio.aws.grafana.model.IdpMetadata.wrap(buildAwsValue())
}
object IdpMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.IdpMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.IdpMetadata = zio.aws.grafana.model
      .IdpMetadata(url.map(value => value), xml.map(value => value))
    def url: Option[IdpMetadataUrl]
    def xml: Option[String]
    def getUrl: ZIO[Any, AwsError, IdpMetadataUrl] =
      AwsError.unwrapOptionField("url", url)
    def getXml: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("xml", xml)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.IdpMetadata
  ) extends zio.aws.grafana.model.IdpMetadata.ReadOnly {
    override val url: Option[IdpMetadataUrl] = scala
      .Option(impl.url())
      .map(value => zio.aws.grafana.model.primitives.IdpMetadataUrl(value))
    override val xml: Option[String] =
      scala.Option(impl.xml()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.IdpMetadata
  ): zio.aws.grafana.model.IdpMetadata.ReadOnly = new Wrapper(impl)
}
