package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.AssertionAttribute
import scala.jdk.CollectionConverters._
final case class AssertionAttributes(
    email: Option[AssertionAttribute] = None,
    groups: Option[AssertionAttribute] = None,
    login: Option[AssertionAttribute] = None,
    name: Option[AssertionAttribute] = None,
    org: Option[AssertionAttribute] = None,
    role: Option[AssertionAttribute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AssertionAttributes = {
    import AssertionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AssertionAttributes
      .builder()
      .optionallyWith(
        email.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        groups.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.groups)
      .optionallyWith(
        login.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.login)
      .optionallyWith(
        name.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        org.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.org)
      .optionallyWith(
        role.map(value => AssertionAttribute.unwrap(value): java.lang.String)
      )(_.role)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.AssertionAttributes.ReadOnly =
    zio.aws.grafana.model.AssertionAttributes.wrap(buildAwsValue())
}
object AssertionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.AssertionAttributes =
      zio.aws.grafana.model.AssertionAttributes(
        email.map(value => value),
        groups.map(value => value),
        login.map(value => value),
        name.map(value => value),
        org.map(value => value),
        role.map(value => value)
      )
    def email: Option[AssertionAttribute]
    def groups: Option[AssertionAttribute]
    def login: Option[AssertionAttribute]
    def name: Option[AssertionAttribute]
    def org: Option[AssertionAttribute]
    def role: Option[AssertionAttribute]
    def getEmail: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("email", email)
    def getGroups: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("groups", groups)
    def getLogin: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("login", login)
    def getName: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("name", name)
    def getOrg: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("org", org)
    def getRole: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ) extends zio.aws.grafana.model.AssertionAttributes.ReadOnly {
    override val email: Option[AssertionAttribute] = scala
      .Option(impl.email())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
    override val groups: Option[AssertionAttribute] = scala
      .Option(impl.groups())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
    override val login: Option[AssertionAttribute] = scala
      .Option(impl.login())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
    override val name: Option[AssertionAttribute] = scala
      .Option(impl.name())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
    override val org: Option[AssertionAttribute] = scala
      .Option(impl.org())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
    override val role: Option[AssertionAttribute] = scala
      .Option(impl.role())
      .map(value => zio.aws.grafana.model.primitives.AssertionAttribute(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ): zio.aws.grafana.model.AssertionAttributes.ReadOnly = new Wrapper(impl)
}
