package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthenticationDescription(
    awsSso: Option[zio.aws.grafana.model.AwsSsoAuthentication] = None,
    providers: Iterable[zio.aws.grafana.model.AuthenticationProviderTypes],
    saml: Option[zio.aws.grafana.model.SamlAuthentication] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AuthenticationDescription = {
    import AuthenticationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AuthenticationDescription
      .builder()
      .optionallyWith(awsSso.map(value => value.buildAwsValue()))(_.awsSso)
      .providersWithStrings(providers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(saml.map(value => value.buildAwsValue()))(_.saml)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.AuthenticationDescription.ReadOnly =
    zio.aws.grafana.model.AuthenticationDescription.wrap(buildAwsValue())
}
object AuthenticationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.AuthenticationDescription =
      zio.aws.grafana.model.AuthenticationDescription(
        awsSso.map(value => value.asEditable),
        providers,
        saml.map(value => value.asEditable)
      )
    def awsSso: Option[zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly]
    def providers: List[zio.aws.grafana.model.AuthenticationProviderTypes]
    def saml: Option[zio.aws.grafana.model.SamlAuthentication.ReadOnly]
    def getAwsSso: ZIO[
      Any,
      AwsError,
      zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("awsSso", awsSso)
    def getProviders: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(providers)
    def getSaml: ZIO[
      Any,
      AwsError,
      zio.aws.grafana.model.SamlAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("saml", saml)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ) extends zio.aws.grafana.model.AuthenticationDescription.ReadOnly {
    override val awsSso
        : Option[zio.aws.grafana.model.AwsSsoAuthentication.ReadOnly] = scala
      .Option(impl.awsSso())
      .map(value => zio.aws.grafana.model.AwsSsoAuthentication.wrap(value))
    override val providers
        : List[zio.aws.grafana.model.AuthenticationProviderTypes] = impl
      .providers()
      .asScala
      .map { item =>
        zio.aws.grafana.model.AuthenticationProviderTypes.wrap(item)
      }
      .toList
    override val saml
        : Option[zio.aws.grafana.model.SamlAuthentication.ReadOnly] = scala
      .Option(impl.saml())
      .map(value => zio.aws.grafana.model.SamlAuthentication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ): zio.aws.grafana.model.AuthenticationDescription.ReadOnly = new Wrapper(
    impl
  )
}
