package zio.aws.grafana.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.UpdateErrorCodeInteger
import scala.jdk.CollectionConverters._
final case class UpdateError(
    causedBy: zio.aws.grafana.model.UpdateInstruction,
    code: UpdateErrorCodeInteger,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateError = {
    import UpdateError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateError
      .builder()
      .causedBy(causedBy.buildAwsValue())
      .code(UpdateErrorCodeInteger.unwrap(code): Integer)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdateError.ReadOnly =
    zio.aws.grafana.model.UpdateError.wrap(buildAwsValue())
}
object UpdateError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateError =
      zio.aws.grafana.model.UpdateError(causedBy.asEditable, code, message)
    def causedBy: zio.aws.grafana.model.UpdateInstruction.ReadOnly
    def code: UpdateErrorCodeInteger
    def message: String
    def getCausedBy
        : ZIO[Any, Nothing, zio.aws.grafana.model.UpdateInstruction.ReadOnly] =
      ZIO.succeed(causedBy)
    def getCode: ZIO[Any, Nothing, UpdateErrorCodeInteger] = ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateError
  ) extends zio.aws.grafana.model.UpdateError.ReadOnly {
    override val causedBy: zio.aws.grafana.model.UpdateInstruction.ReadOnly =
      zio.aws.grafana.model.UpdateInstruction.wrap(impl.causedBy())
    override val code: UpdateErrorCodeInteger =
      zio.aws.grafana.model.primitives.UpdateErrorCodeInteger(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateError
  ): zio.aws.grafana.model.UpdateError.ReadOnly = new Wrapper(impl)
}
