package zio.aws.grafana.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  PaginationToken,
  ListPermissionsRequestMaxResultsInteger,
  SsoId
}
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    groupId: Option[SsoId] = None,
    maxResults: Option[ListPermissionsRequestMaxResultsInteger] = None,
    nextToken: Option[PaginationToken] = None,
    userId: Option[SsoId] = None,
    userType: Option[zio.aws.grafana.model.UserType] = None,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
      .builder()
      .optionallyWith(
        groupId.map(value => SsoId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        maxResults.map(value =>
          ListPermissionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        userId.map(value => SsoId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListPermissionsRequest.ReadOnly =
    zio.aws.grafana.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListPermissionsRequest =
      zio.aws.grafana.model.ListPermissionsRequest(
        groupId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        userId.map(value => value),
        userType.map(value => value),
        workspaceId
      )
    def groupId: Option[SsoId]
    def maxResults: Option[ListPermissionsRequestMaxResultsInteger]
    def nextToken: Option[PaginationToken]
    def userId: Option[SsoId]
    def userType: Option[zio.aws.grafana.model.UserType]
    def workspaceId: WorkspaceId
    def getGroupId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getMaxResults
        : ZIO[Any, AwsError, ListPermissionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserType: ZIO[Any, AwsError, zio.aws.grafana.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ) extends zio.aws.grafana.model.ListPermissionsRequest.ReadOnly {
    override val groupId: Option[SsoId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.grafana.model.primitives.SsoId(value))
    override val maxResults: Option[ListPermissionsRequestMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.grafana.model.primitives
            .ListPermissionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
    override val userId: Option[SsoId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.grafana.model.primitives.SsoId(value))
    override val userType: Option[zio.aws.grafana.model.UserType] = scala
      .Option(impl.userType())
      .map(value => zio.aws.grafana.model.UserType.wrap(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ): zio.aws.grafana.model.ListPermissionsRequest.ReadOnly = new Wrapper(impl)
}
