package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceResponse(
    workspace: zio.aws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse = {
    import DescribeWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceResponse.wrap(buildAwsValue())
}
object DescribeWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.DescribeWorkspaceResponse =
      zio.aws.grafana.model.DescribeWorkspaceResponse(workspace.asEditable)
    def workspace: zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    def getWorkspace: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ) extends zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly {
    override val workspace
        : zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
      zio.aws.grafana.model.WorkspaceDescription.wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ): zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
