package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceType {
  def unwrap: software.amazon.awssdk.services.grafana.model.DataSourceType
}
object DataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.DataSourceType
  ): zio.aws.grafana.model.DataSourceType = value match {
    case software.amazon.awssdk.services.grafana.model.DataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE =>
      val r = AMAZON_OPENSEARCH_SERVICE
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.CLOUDWATCH =>
      val r = CLOUDWATCH
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.PROMETHEUS =>
      val r = PROMETHEUS
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.XRAY =>
      val r = XRAY
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.TIMESTREAM =>
      val r = TIMESTREAM
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.SITEWISE =>
      val r = SITEWISE
      r
  }
  case object unknownToSdkVersion extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AMAZON_OPENSEARCH_SERVICE
      extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE
  }
  case object CLOUDWATCH extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.CLOUDWATCH
  }
  case object PROMETHEUS extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.PROMETHEUS
  }
  case object XRAY extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.XRAY
  }
  case object TIMESTREAM extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.TIMESTREAM
  }
  case object SITEWISE extends zio.aws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.SITEWISE
  }
}
