package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  WorkspaceName,
  WorkspaceId,
  Description
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkspaceRequest(
    accountAccessType: Option[zio.aws.grafana.model.AccountAccessType] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    permissionType: Option[zio.aws.grafana.model.PermissionType] = None,
    stackSetName: Option[StackSetName] = None,
    workspaceDataSources: Option[
      Iterable[zio.aws.grafana.model.DataSourceType]
    ] = None,
    workspaceDescription: Option[Description] = None,
    workspaceId: WorkspaceId,
    workspaceName: Option[WorkspaceName] = None,
    workspaceNotificationDestinations: Option[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = None,
    workspaceOrganizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest = {
    import UpdateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.workspaceDescription)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        workspaceName.map(value =>
          WorkspaceName.unwrap(value): java.lang.String
        )
      )(_.workspaceName)
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceRequest.wrap(buildAwsValue())
}
object UpdateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceRequest =
      zio.aws.grafana.model.UpdateWorkspaceRequest(
        accountAccessType.map(value => value),
        organizationRoleName.map(value => value),
        permissionType.map(value => value),
        stackSetName.map(value => value),
        workspaceDataSources.map(value => value),
        workspaceDescription.map(value => value),
        workspaceId,
        workspaceName.map(value => value),
        workspaceNotificationDestinations.map(value => value),
        workspaceOrganizationalUnits.map(value => value),
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: Option[zio.aws.grafana.model.AccountAccessType]
    def organizationRoleName: Option[OrganizationRoleName]
    def permissionType: Option[zio.aws.grafana.model.PermissionType]
    def stackSetName: Option[StackSetName]
    def workspaceDataSources: Option[List[zio.aws.grafana.model.DataSourceType]]
    def workspaceDescription: Option[Description]
    def workspaceId: WorkspaceId
    def workspaceName: Option[WorkspaceName]
    def workspaceNotificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]]
    def workspaceOrganizationalUnits: Option[List[OrganizationalUnit]]
    def workspaceRoleArn: Option[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, AwsError, zio.aws.grafana.model.AccountAccessType] =
      AwsError.unwrapOptionField("accountAccessType", accountAccessType)
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getPermissionType
        : ZIO[Any, AwsError, zio.aws.grafana.model.PermissionType] =
      AwsError.unwrapOptionField("permissionType", permissionType)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getWorkspaceDataSources
        : ZIO[Any, AwsError, List[zio.aws.grafana.model.DataSourceType]] =
      AwsError.unwrapOptionField("workspaceDataSources", workspaceDataSources)
    def getWorkspaceDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("workspaceDescription", workspaceDescription)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getWorkspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceName)
    def getWorkspaceNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinations
    )
    def getWorkspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnits
      )
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ) extends zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly {
    override val accountAccessType
        : Option[zio.aws.grafana.model.AccountAccessType] = scala
      .Option(impl.accountAccessType())
      .map(value => zio.aws.grafana.model.AccountAccessType.wrap(value))
    override val organizationRoleName: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value =>
        zio.aws.grafana.model.primitives.OrganizationRoleName(value)
      )
    override val permissionType: Option[zio.aws.grafana.model.PermissionType] =
      scala
        .Option(impl.permissionType())
        .map(value => zio.aws.grafana.model.PermissionType.wrap(value))
    override val stackSetName: Option[StackSetName] = scala
      .Option(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val workspaceDataSources
        : Option[List[zio.aws.grafana.model.DataSourceType]] = scala
      .Option(impl.workspaceDataSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.DataSourceType.wrap(item)
        }.toList
      )
    override val workspaceDescription: Option[Description] = scala
      .Option(impl.workspaceDescription())
      .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
    override val workspaceName: Option[WorkspaceName] = scala
      .Option(impl.workspaceName())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val workspaceNotificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]] =
      scala
        .Option(impl.workspaceNotificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val workspaceOrganizationalUnits
        : Option[List[OrganizationalUnit]] = scala
      .Option(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.OrganizationalUnit(item)
        }.toList
      )
    override val workspaceRoleArn: Option[IamRoleArn] = scala
      .Option(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ): zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
