package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SamlAuthentication(
    configuration: Option[zio.aws.grafana.model.SamlConfiguration] = None,
    status: zio.aws.grafana.model.SamlConfigurationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.SamlAuthentication = {
    import SamlAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.SamlAuthentication
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.SamlAuthentication.ReadOnly =
    zio.aws.grafana.model.SamlAuthentication.wrap(buildAwsValue())
}
object SamlAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.SamlAuthentication =
      zio.aws.grafana.model.SamlAuthentication(
        configuration.map(value => value.asEditable),
        status
      )
    def configuration: Option[zio.aws.grafana.model.SamlConfiguration.ReadOnly]
    def status: zio.aws.grafana.model.SamlConfigurationStatus
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.grafana.model.SamlConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.grafana.model.SamlConfigurationStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ) extends zio.aws.grafana.model.SamlAuthentication.ReadOnly {
    override val configuration
        : Option[zio.aws.grafana.model.SamlConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.grafana.model.SamlConfiguration.wrap(value))
    override val status: zio.aws.grafana.model.SamlConfigurationStatus =
      zio.aws.grafana.model.SamlConfigurationStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ): zio.aws.grafana.model.SamlAuthentication.ReadOnly = new Wrapper(impl)
}
