package zio.aws.grafana
import software.amazon.awssdk.services.grafana.{
  GrafanaAsyncClientBuilder,
  GrafanaAsyncClient
}
import zio.aws.grafana.model.{
  CreateWorkspaceRequest,
  DescribeWorkspaceAuthenticationRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  DescribeWorkspaceRequest,
  AssociateLicenseRequest,
  UpdateWorkspaceAuthenticationRequest,
  UpdatePermissionsRequest,
  ListPermissionsRequest,
  DisassociateLicenseRequest,
  UpdateWorkspaceRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.grafana.model.AssociateLicenseResponse.ReadOnly
import software.amazon.awssdk.services.grafana.paginators.{
  ListPermissionsPublisher,
  ListWorkspacesPublisher
}
import software.amazon.awssdk.services.grafana.model.{
  PermissionEntry,
  CreateWorkspaceResponse,
  UpdateWorkspaceAuthenticationResponse,
  DescribeWorkspaceResponse,
  WorkspaceSummary,
  DeleteWorkspaceResponse,
  ListWorkspacesResponse,
  ListPermissionsResponse,
  AssociateLicenseResponse,
  DescribeWorkspaceAuthenticationResponse,
  UpdateWorkspaceResponse,
  UpdatePermissionsResponse,
  DisassociateLicenseResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Grafana extends AspectSupport[Grafana] {
  val api: GrafanaAsyncClient
  def describeWorkspace(
      request: DescribeWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly]
  def disassociateLicense(
      request: DisassociateLicenseRequest
  ): IO[AwsError, zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly]
  def updatePermissions(
      request: UpdatePermissionsRequest
  ): IO[AwsError, zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly]
  def createWorkspace(
      request: CreateWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly]
  def updateWorkspaceAuthentication(
      request: UpdateWorkspaceAuthenticationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
  ]
  def listWorkspaces(
      request: ListWorkspacesRequest
  ): ZStream[Any, AwsError, zio.aws.grafana.model.WorkspaceSummary.ReadOnly]
  def listWorkspacesPaginated(
      request: ListWorkspacesRequest
  ): IO[AwsError, zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly]
  def associateLicense(request: AssociateLicenseRequest): IO[AwsError, ReadOnly]
  def listPermissions(
      request: ListPermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.grafana.model.PermissionEntry.ReadOnly]
  def listPermissionsPaginated(
      request: ListPermissionsRequest
  ): IO[AwsError, zio.aws.grafana.model.ListPermissionsResponse.ReadOnly]
  def deleteWorkspace(
      request: DeleteWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly]
  def describeWorkspaceAuthentication(
      request: DescribeWorkspaceAuthenticationRequest
  ): IO[
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
  ]
  def updateWorkspace(
      request: UpdateWorkspaceRequest
  ): IO[AwsError, zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly]
}
object Grafana {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Grafana] = customized(
    identity
  )
  def customized(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Grafana] = managed(
    customization
  ).toLayer
  def managed(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Grafana] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = GrafanaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[GrafanaAsyncClient, GrafanaAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[GrafanaAsyncClient, GrafanaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new GrafanaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class GrafanaImpl[R](
      override val api: GrafanaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Grafana
      with AwsServiceBase[R] {
    override val serviceName: String = "Grafana"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GrafanaImpl[R1] = new GrafanaImpl(api, newAspect, r)
    def describeWorkspace(
        request: DescribeWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest,
        DescribeWorkspaceResponse
      ]("describeWorkspace", api.describeWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.DescribeWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def disassociateLicense(request: DisassociateLicenseRequest): IO[
      AwsError,
      zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest,
      DisassociateLicenseResponse
    ]("disassociateLicense", api.disassociateLicense)(request.buildAwsValue())
      .map(zio.aws.grafana.model.DisassociateLicenseResponse.wrap)
      .provideEnvironment(r)
    def updatePermissions(
        request: UpdatePermissionsRequest
    ): IO[AwsError, zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest,
        UpdatePermissionsResponse
      ]("updatePermissions", api.updatePermissions)(request.buildAwsValue())
        .map(zio.aws.grafana.model.UpdatePermissionsResponse.wrap)
        .provideEnvironment(r)
    def createWorkspace(
        request: CreateWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest,
        CreateWorkspaceResponse
      ]("createWorkspace", api.createWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.CreateWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def updateWorkspaceAuthentication(
        request: UpdateWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest,
      UpdateWorkspaceAuthenticationResponse
    ]("updateWorkspaceAuthentication", api.updateWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.wrap)
      .provideEnvironment(r)
    def listWorkspaces(
        request: ListWorkspacesRequest
    ): ZStream[Any, AwsError, zio.aws.grafana.model.WorkspaceSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest,
        WorkspaceSummary,
        ListWorkspacesPublisher
      ]("listWorkspaces", api.listWorkspacesPaginator, _.workspaces())(
        request.buildAwsValue()
      ).map(item => zio.aws.grafana.model.WorkspaceSummary.wrap(item))
        .provideEnvironment(r)
    def listWorkspacesPaginated(
        request: ListWorkspacesRequest
    ): IO[AwsError, zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest,
        ListWorkspacesResponse
      ]("listWorkspaces", api.listWorkspaces)(request.buildAwsValue())
        .map(zio.aws.grafana.model.ListWorkspacesResponse.wrap)
        .provideEnvironment(r)
    def associateLicense(
        request: AssociateLicenseRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest,
      AssociateLicenseResponse
    ]("associateLicense", api.associateLicense)(request.buildAwsValue())
      .map(zio.aws.grafana.model.AssociateLicenseResponse.wrap)
      .provideEnvironment(r)
    def listPermissions(
        request: ListPermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.grafana.model.PermissionEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.grafana.model.ListPermissionsRequest,
        PermissionEntry,
        ListPermissionsPublisher
      ]("listPermissions", api.listPermissionsPaginator, _.permissions())(
        request.buildAwsValue()
      ).map(item => zio.aws.grafana.model.PermissionEntry.wrap(item))
        .provideEnvironment(r)
    def listPermissionsPaginated(
        request: ListPermissionsRequest
    ): IO[AwsError, zio.aws.grafana.model.ListPermissionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.ListPermissionsRequest,
        ListPermissionsResponse
      ]("listPermissions", api.listPermissions)(request.buildAwsValue())
        .map(zio.aws.grafana.model.ListPermissionsResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkspace(
        request: DeleteWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest,
        DeleteWorkspaceResponse
      ]("deleteWorkspace", api.deleteWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.DeleteWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def describeWorkspaceAuthentication(
        request: DescribeWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest,
      DescribeWorkspaceAuthenticationResponse
    ]("describeWorkspaceAuthentication", api.describeWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.wrap)
      .provideEnvironment(r)
    def updateWorkspace(
        request: UpdateWorkspaceRequest
    ): IO[AwsError, zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest,
        UpdateWorkspaceResponse
      ]("updateWorkspace", api.updateWorkspace)(request.buildAwsValue())
        .map(zio.aws.grafana.model.UpdateWorkspaceResponse.wrap)
        .provideEnvironment(r)
  }
  def describeWorkspace(request: DescribeWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspace(request))
  def disassociateLicense(request: DisassociateLicenseRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DisassociateLicenseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateLicense(request))
  def updatePermissions(request: UpdatePermissionsRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdatePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePermissions(request))
  def createWorkspace(request: CreateWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspace(request))
  def updateWorkspaceAuthentication(
      request: UpdateWorkspaceAuthenticationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspaceAuthentication(request))
  def listWorkspaces(request: ListWorkspacesRequest): ZStream[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.WorkspaceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkspaces(request))
  def listWorkspacesPaginated(request: ListWorkspacesRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkspacesPaginated(request))
  def associateLicense(
      request: AssociateLicenseRequest
  ): ZIO[zio.aws.grafana.Grafana, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.associateLicense(request))
  def listPermissions(request: ListPermissionsRequest): ZStream[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.PermissionEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissions(request))
  def listPermissionsPaginated(request: ListPermissionsRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.ListPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionsPaginated(request))
  def deleteWorkspace(request: DeleteWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspace(request))
  def describeWorkspaceAuthentication(
      request: DescribeWorkspaceAuthenticationRequest
  ): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceAuthentication(request))
  def updateWorkspace(request: UpdateWorkspaceRequest): ZIO[
    zio.aws.grafana.Grafana,
    AwsError,
    zio.aws.grafana.model.UpdateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspace(request))
}
