package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorkspacesResponse(
    nextToken: Option[PaginationToken] = None,
    workspaces: Iterable[zio.aws.grafana.model.WorkspaceSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse = {
    import ListWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workspaces(workspaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly =
    zio.aws.grafana.model.ListWorkspacesResponse.wrap(buildAwsValue())
}
object ListWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListWorkspacesResponse =
      zio.aws.grafana.model.ListWorkspacesResponse(
        nextToken.map(value => value),
        workspaces.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[PaginationToken]
    def workspaces: List[zio.aws.grafana.model.WorkspaceSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaces: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.WorkspaceSummary.ReadOnly
    ]] = ZIO.succeed(workspaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ) extends zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
    override val workspaces
        : List[zio.aws.grafana.model.WorkspaceSummary.ReadOnly] = impl
      .workspaces()
      .asScala
      .map { item =>
        zio.aws.grafana.model.WorkspaceSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ): zio.aws.grafana.model.ListWorkspacesResponse.ReadOnly = new Wrapper(impl)
}
