package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  WorkspaceName,
  Description,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateWorkspaceRequest(
    accountAccessType: zio.aws.grafana.model.AccountAccessType,
    authenticationProviders: Iterable[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ],
    clientToken: Option[ClientToken] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    permissionType: zio.aws.grafana.model.PermissionType,
    stackSetName: Option[StackSetName] = None,
    workspaceDataSources: Option[
      Iterable[zio.aws.grafana.model.DataSourceType]
    ] = None,
    workspaceDescription: Option[Description] = None,
    workspaceName: Option[WorkspaceName] = None,
    workspaceNotificationDestinations: Option[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = None,
    workspaceOrganizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest = {
    import CreateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
      .builder()
      .accountAccessType(accountAccessType.unwrap)
      .authenticationProvidersWithStrings(authenticationProviders.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .permissionType(permissionType.unwrap)
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.workspaceDescription)
      .optionallyWith(
        workspaceName.map(value =>
          WorkspaceName.unwrap(value): java.lang.String
        )
      )(_.workspaceName)
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.CreateWorkspaceRequest.wrap(buildAwsValue())
}
object CreateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.CreateWorkspaceRequest =
      zio.aws.grafana.model.CreateWorkspaceRequest(
        accountAccessType,
        authenticationProviders,
        clientToken.map(value => value),
        organizationRoleName.map(value => value),
        permissionType,
        stackSetName.map(value => value),
        workspaceDataSources.map(value => value),
        workspaceDescription.map(value => value),
        workspaceName.map(value => value),
        workspaceNotificationDestinations.map(value => value),
        workspaceOrganizationalUnits.map(value => value),
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: zio.aws.grafana.model.AccountAccessType
    def authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes]
    def clientToken: Option[ClientToken]
    def organizationRoleName: Option[OrganizationRoleName]
    def permissionType: zio.aws.grafana.model.PermissionType
    def stackSetName: Option[StackSetName]
    def workspaceDataSources: Option[List[zio.aws.grafana.model.DataSourceType]]
    def workspaceDescription: Option[Description]
    def workspaceName: Option[WorkspaceName]
    def workspaceNotificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]]
    def workspaceOrganizationalUnits: Option[List[OrganizationalUnit]]
    def workspaceRoleArn: Option[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, Nothing, zio.aws.grafana.model.AccountAccessType] =
      ZIO.succeed(accountAccessType)
    def getAuthenticationProviders: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(authenticationProviders)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getPermissionType
        : ZIO[Any, Nothing, zio.aws.grafana.model.PermissionType] =
      ZIO.succeed(permissionType)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getWorkspaceDataSources
        : ZIO[Any, AwsError, List[zio.aws.grafana.model.DataSourceType]] =
      AwsError.unwrapOptionField("workspaceDataSources", workspaceDataSources)
    def getWorkspaceDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("workspaceDescription", workspaceDescription)
    def getWorkspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceName)
    def getWorkspaceNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinations
    )
    def getWorkspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnits
      )
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ) extends zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly {
    override val accountAccessType: zio.aws.grafana.model.AccountAccessType =
      zio.aws.grafana.model.AccountAccessType.wrap(impl.accountAccessType())
    override val authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes] = impl
      .authenticationProviders()
      .asScala
      .map { item =>
        zio.aws.grafana.model.AuthenticationProviderTypes.wrap(item)
      }
      .toList
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.grafana.model.primitives.ClientToken(value))
    override val organizationRoleName: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value =>
        zio.aws.grafana.model.primitives.OrganizationRoleName(value)
      )
    override val permissionType: zio.aws.grafana.model.PermissionType =
      zio.aws.grafana.model.PermissionType.wrap(impl.permissionType())
    override val stackSetName: Option[StackSetName] = scala
      .Option(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val workspaceDataSources
        : Option[List[zio.aws.grafana.model.DataSourceType]] = scala
      .Option(impl.workspaceDataSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.DataSourceType.wrap(item)
        }.toList
      )
    override val workspaceDescription: Option[Description] = scala
      .Option(impl.workspaceDescription())
      .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val workspaceName: Option[WorkspaceName] = scala
      .Option(impl.workspaceName())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val workspaceNotificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]] =
      scala
        .Option(impl.workspaceNotificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val workspaceOrganizationalUnits
        : Option[List[OrganizationalUnit]] = scala
      .Option(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.OrganizationalUnit(item)
        }.toList
      )
    override val workspaceRoleArn: Option[IamRoleArn] = scala
      .Option(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ): zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
