package zio.aws.grafana.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  PaginationToken,
  ListWorkspacesRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters._
final case class ListWorkspacesRequest(
    maxResults: Option[ListWorkspacesRequestMaxResultsInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest = {
    import ListWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListWorkspacesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly =
    zio.aws.grafana.model.ListWorkspacesRequest.wrap(buildAwsValue())
}
object ListWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListWorkspacesRequest =
      zio.aws.grafana.model.ListWorkspacesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListWorkspacesRequestMaxResultsInteger]
    def nextToken: Option[PaginationToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListWorkspacesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ) extends zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly {
    override val maxResults: Option[ListWorkspacesRequestMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.grafana.model.primitives
            .ListWorkspacesRequestMaxResultsInteger(value)
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ): zio.aws.grafana.model.ListWorkspacesRequest.ReadOnly = new Wrapper(impl)
}
