package zio.aws.grafana.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationProviderTypes {
  def unwrap: software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes
}
object AuthenticationProviderTypes {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes
  ): zio.aws.grafana.model.AuthenticationProviderTypes = value match {
    case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.AWS_SSO =>
      val r = AWS_SSO
      r
    case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.SAML =>
      val r = SAML
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_SSO
      extends zio.aws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.AWS_SSO
  }
  case object SAML extends zio.aws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.SAML
  }
}
