package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.Protocol
  ): zio.aws.globalaccelerator.model.Protocol = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.Protocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.globalaccelerator.model.Protocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.Protocol =
      software.amazon.awssdk.services.globalaccelerator.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.globalaccelerator.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.Protocol =
      software.amazon.awssdk.services.globalaccelerator.model.Protocol.TCP
  }
  case object UDP extends zio.aws.globalaccelerator.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.Protocol =
      software.amazon.awssdk.services.globalaccelerator.model.Protocol.UDP
  }
}
