package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.AwsAccountId
import scala.jdk.CollectionConverters._
final case class ListCrossAccountResourceAccountsResponse(
    resourceOwnerAwsAccountIds: Optional[Iterable[AwsAccountId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse = {
    import ListCrossAccountResourceAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse
      .builder()
      .optionallyWith(
        resourceOwnerAwsAccountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceOwnerAwsAccountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse
      .wrap(buildAwsValue())
}
object ListCrossAccountResourceAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse =
      zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse(
        resourceOwnerAwsAccountIds.map(value => value)
      )
    def resourceOwnerAwsAccountIds: Optional[List[AwsAccountId]]
    def getResourceOwnerAwsAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField(
        "resourceOwnerAwsAccountIds",
        resourceOwnerAwsAccountIds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse
  ) extends zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse.ReadOnly {
    override val resourceOwnerAwsAccountIds: Optional[List[AwsAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceOwnerAwsAccountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.AwsAccountId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse
  ): zio.aws.globalaccelerator.model.ListCrossAccountResourceAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
